# -*- coding: utf-8 -*-
"""r03.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1w8tflZg6wv46ljylZ6w0CtIpNXxOKooq

# Rozdział 3.
"""

# importowanie bibliotek
import numpy as np
import matplotlib.pyplot as plt


# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki

"""# Ważona kombinacja liniowa"""

# skalary
l1 = 1
l2 = 2
l3 = -3

# wektory
v1 = np.array([4,5,1])
v2 = np.array([-4,0,-4])
v3 = np.array([1,3,2])

# ważona kombinacja liniowa
l1*v1 + l2*v2 + l3*v3



"""# Wektory bazowe i punkty"""

p = (3,1)
q = (-6,2)

plt.figure(figsize=(6,6))

plt.plot(p[0],p[1],'ko',markerfacecolor='k',markersize=10,label='Punkt p')
plt.plot(q[0],q[1],'ks',markerfacecolor='k',markersize=10,label='Punkt q')

plt.plot([0,0],[0,1],'k',linewidth=3,label='Baza S')
plt.plot([0,1],[0,0],'k',linewidth=3)

plt.plot([0,3],[0,1],'k--',linewidth=3,label='Baza T')
plt.plot([0,-3],[0,1],'k--',linewidth=3)


plt.axis('square')
plt.grid(linestyle='--',color=[.8,.8,.8])
plt.xlim([-7,7])
plt.ylim([-7,7])
plt.legend()
plt.savefig('rys3.4.png',dpi=300)
plt.show()



"""# Ćwiczenia

# Ćwiczenie 1.
"""

# Uwaga: Upewnij się, że uruchomiłeś powyższy kod tworzący zmienne l1, l2, itd.

# umieszczam wartości w listach
scalars = [ l1,l2,l3 ]
vectors = [ v1,v2,v3 ]

# inicjalizuję zmienną do przechowywania wyniku
linCombo = np.zeros(len(v1))

# implementacja ważonej kombinacji liniowej za pomocą zip()
for s,v in zip(scalars,vectors):
  linCombo += s*v

# upewniam się, że otrzymałem ten sam wynik
linCombo



"""# Ćwiczenie 2."""

# O tym, czy zip() zwróci błąd decyduje sposób implementacji.
# Użycie zip() tak jak w powyższym przykładzie nie prowadzi do błędu, ponieważ funkcja
# ta dopasowuje do siebie najmniejszą możliwą liczbę elementów. Natomiast użycie indeksowania
# spowoduje błąd widoczny po uruchomieniu poniższego kodu.

# lista skalarów jest dłuższa od listy wektorów
scalars = [ l1,l2,l3,5 ]
vectors = [ v1,v2,v3 ]

linCombo = np.zeros(len(v1))

for i in range(len(scalars)):
  linCombo += scalars[i]*vectors[i]



"""# Exercise 3"""

# zbiór wektorów (zawierający tylko jeden wektor)
A  = np.array([ 1,3 ])

# zakres wartości na osi x
xlim = [-4,4]

# generowanie losowych skalarów
scalars = np.random.uniform(low=xlim[0],high=xlim[1],size=100)



# tworzenie wykresu
plt.figure(figsize=(6,6))

# pętla po losowych skalarach
for s in scalars:

  # tworzę punkt p
  p = A*s

  # i go wykreślam
  plt.plot(p[0],p[1],'ko')


plt.xlim(xlim)
plt.ylim(xlim)
plt.grid()
plt.text(-4.5,4.5,'A)',fontweight='bold',fontsize=18)
plt.savefig('rys3.7a.png',dpi=300)
plt.show()

import plotly.graph_objects as go

# dwa wektory z R3
v1 = np.array([ 3,5,1 ])
v2 = np.array([ 0,2,2 ])

## odkomentuj, aby uruchomić drugą cześć zadania
# v1 = np.array([ 3.0,5.0,1.0 ])
# v2 = np.array([ 1.5,2.5,0.5 ])


# generowanie losowych skalarów w zakresie osi x
scalars = np.random.uniform(low=xlim[0],high=xlim[1],size=(100,2))



# tworzenie losowych punktów
points = np.zeros((100,3))
for i in range(len(scalars)):

  # punkty to kombinacja liniowa losowych wartości z wektorami
  points[i,:] = v1*scalars[i,0] + v2*scalars[i,1]


# rysowanie kropek na płaszczyźnie
fig = go.Figure( data=[go.Scatter3d(x=points[:,0], y=points[:,1], z=points[:,2],
                                    mode='markers', marker=dict(size=6,color='black') )])

fig.update_layout(margin=dict(l=0,r=0,b=0,t=0))
plt.savefig('rys3.7b.png',dpi=300)
fig.show()

